* Title: 	census_migration_clean.do
* Version: 	23 May 2018
* Purpose: 	Clean CPS migration table from Census

* Source: https://www.census.gov/data/tables/time-series/demo/geographic-mobility/historic.html, Table A-1
* Date accessed: 5 February 2018

*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using log/census_migration_clean, replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load and clean spreadsheet
*******************************************************************************

import excel using dta/raw/census_migration.xls, clear
keep A B D F G I
ren A Period
ren B Total
ren D Migrants
ren F Intracounty
ren G Intercounty
ren I Interstate

* Keep only levels
drop if Period == ""
gen flag1 = (Period == "NUMBER")
gen sumflag1 = sum(flag1)
gen flag2 = (Period == "PERCENT")
gen sumflag2 = sum(flag2)
keep if (sumflag1 == 1 & sumflag2 == 0)
drop if (Period == "NUMBER")

* Drop selected year/control entries
drop if strpos(Period,"2010-2011 (2000 controls)") 			> 0
drop if strpos(Period,"2009-2010 (2000 controls)") 			> 0
drop if strpos(Period,"2000-2001 (SCHIP, 2000 controls)") 	> 0
drop if strpos(Period,"2000-2001 (1990 controls)") 			> 0
drop if strpos(Period,"1992-1993 (1980 controls)") 			> 0

gen Year = substr(Period,6,4)
isid Year
order Year

*******************************************************************************
* (2) End of file
*******************************************************************************

keep 	Year Total Migrants Intracounty Intercounty Interstate
destring _all, replace
sort Year

compress

save dta/census_migration_clean, replace

log close
exit, clear
